﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.BusinessData.Runtime;

namespace BCS.Northwind
{
   /// <summary>
   /// All the methods for retrieving, updating and deleting data are implemented in this class file.
   /// The samples below show the finder and specific finder method for a Customer.
   /// </summary>
   public class CustomerService
   {
      /// <summary>
      /// This is a sample specific finder method for a Customer.
      /// If you want to delete or rename the method think about changing the xml in the BDC model file as well.
      /// </summary>
      /// <param name="id"></param>
      /// <returns>Customer</returns>
      public static Customer ReadItem(string id)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               var customer = context.Customer.Where(c => c.CustomerID == id).SingleOrDefault();
               return customer;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      /// <summary>
      /// This is a sample finder method for a Customer.
      /// If you want to delete or rename the method think about changing the xml in the BDC model file as well.
      /// </summary>
      /// <returns>IEnumerable of Customers</returns>
      public static IEnumerable<Customer> ReadList()
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               // return as list, so the objects are read before the context is disposed
               List<Customer> customers = context.Customer.ToList();
               return customers;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static void Update(string customerId, Customer customer)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               var oldCustomer = context.Customer.Where(c => c.CustomerID == customerId).Single();
               oldCustomer.UpdateWith(customer);
               context.SubmitChanges();
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static Customer Create(Customer newCustomer)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               context.Customer.InsertOnSubmit(newCustomer);
               context.SubmitChanges();
               return newCustomer;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static IEnumerable<Order> CustomerToOrder(string customerID)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               List<Order> orders;
               orders = (from o in context.Order
                         where o.CustomerID == customerID
                         select o).ToList();
               return orders;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static void Delete(string customerID)
      {
         throw new System.NotImplementedException();
      }
   }
}
